CREATE FUNCTION fn_Kapcsolatok (@prmDazon char(5))
RETURNS @retBeosztottak TABLE (dazon char(5) primary key,
   dnev nvarchar(50) NOT NULL,
   dfonok char(5),
   dbeoszt nvarchar(30))
/*A visszaadott tbla az adott dolgoz kzvetlen vagy kzvetett beosztottjait tartalmazza.*/
AS
BEGIN
   DECLARE @Sorok int
   -- Segdtbla a gyjtsekhez
   DECLARE @kapcsolatok TABLE (dazon char(5) primary key, 
      dnev nvarchar(50) NOT NULL,
      dfonok char(5),
      dbeoszt nvarchar(30),
      djelzo tinyint default 0)
-- Az adott dolgozhoz kigyjti a kapcsolatokat 
   INSERT @kapcsolatok
   SELECT dazon, dnev, dfonok, dbeoszt, 0
   	FROM dolg 
   	WHERE dazon = @prmDazon 

   SET @Sorok = @@rowcount
   -- j kapcsold dolgozk keresse
   WHILE @Sorok > 0
   	BEGIN
      		/*A kzvetlen beosztottak megkeresse, megjells 1-re.*/
      		UPDATE @kapcsolatok
      			SET djelzo = 1
      			WHERE djelzo = 0
      
		-- Beszrja azokat a dolgozkat, akik kzvetlenl az 1 jelek beosztottjai.
      		INSERT @kapcsolatok
      		SELECT d.dazon, d.dnev, d.dfonok, d.dbeoszt, 0
      			FROM dolg d, @kapcsolatok k
      			WHERE d.dfonok=k.dazon and d.dfonok <> d.dazon and k.djelzo = 1
      
      		SET @Sorok = @@rowcount
      		/*Megjelli az sszes olyan dolgozt, aki kzvetlen fnk.*/
      		UPDATE @kapcsolatok
      			SET djelzo = 2
      			WHERE djelzo = 1
   	END
   
   -- A visszatrsi tbla ellltsa
   INSERT @retBeosztottak
   SELECT dazon, dnev, dfonok, dbeoszt 
   	FROM @kapcsolatok
   RETURN
END
GO
